﻿Public Class Form5
    Dim Puntos As Integer
    Dim TiempoRestante As Integer
    Dim PreguntaActual As Integer
    Dim RespuestasCorrectas As Integer
    Dim Correctas() As Integer = {1, 4, 3, 4, 1, 4, 1, 3, 3, 1, 4, 2, 3, 2, 3, 3, 1, 3, 2, 3}
    Dim OpcionesRB() As RadioButton ' Array para manejar los RadioButtons

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Inicializamos el array de RadioButtons
        OpcionesRB = {RadioButton1, RadioButton2, RadioButton3, RadioButton4}

        IniciarJuego()
        Timer1.Interval = 1000
        Timer1.Start()
    End Sub

    Sub IniciarJuego()
        Puntos = 100
        TiempoRestante = 120
        PreguntaActual = 0
        RespuestasCorrectas = 0

        Label3.Text = "Puntos: " & Puntos
        ActualizarTiempo()
        CargarPregunta()
    End Sub

    Sub CargarPregunta()
        Dim Preguntas() As String = {
            "¿Qué es el puntero?", "¿Qué es el Clic?", "¿Qué es un icono?", "¿Qué es el cursor?",
            "¿Qué es Software?", "¿Qué es el hardware?", "¿Qué combinación de teclas sirve para borrar una acción realizada anteriormente?",
            "¿Qué combinación de teclas sirve para copiar una imagen o texto?", "¿Qué combinación de teclas sirve para pegar una imagen o texto anteriormente copiado?",
            "Seleccione un tipo de archivo de música", "Seleccione un tipo de archivo de video", "Seleccione un tipo de archivo de texto",
            "Seleccione un tipo de archivo de imagen", "¿Qué tipo de mantenimiento existen?", "¿Cuáles son los hackers éticos?",
            "¿Cuáles son los hackers ciberdelincuentes?", "¿Cuántas teclas puede llegar a tener un teclado?", "¿Qué es el CPU?",
            "¿Qué programa de Microsoft permite crear aplicaciones de escritorio?", "¿Para qué funciona el TextBox en VB?"
        }

        Dim Opciones(,) As String = {
            {"Representación gráfica del movimiento del mouse", "Ctrl+Z", "Parte intangible de la computadora", "Nos indica donde estamos escribiendo"},
            {"Azul", "Hacker", "Representación gráfica de una función", "Es presionar una sola vez el botón izquierdo del mouse"},
            {"Ctrl+X", "Ctrl+C", "Es la representación gráfica de una función", "Es todo lo que se puede tocar de una computadora"},
            {"Sí", "El mouse", "Nos indica donde estamos escribiendo", "Sirve para ingresar información"},
            {"Es la parte intangible de la computadora", "Es todo lo que se puede tocar de una computadora", "Pantalla", "Mouse"},
            {"Rojo y azul", "Cursor", "MP3", "Es todo lo que se puede tocar de una computadora"},
            {"Ctrl+Z", "Ctrl+X", "Ctrl+O", "Ctrl+C"},
            {"Ctrl+K", "Ctrl+O", "Ctrl+C", "Ctrl+M"},
            {"Ctrl+Shift", "Ctrl+V", "Ctrl+X", "Ctrl+3"},
            {"MP3", "JPG", "HBO", "TXT"},
            {"JPG", "X13", "C++", "MP4"},
            {"MP4", "TXT", "MP3", "HBO"},
            {"TXT", "MP3", "JPG", "C++"},
            {"Hackers de sombrero blanco", "Preventivo y Correctivo", "MP3", "De 100 a 120"},
            {"Hackers de sombrero morado", "Hackers de sombrero gris", "Hackers de sombrero blanco", "Hackers buenos"},
            {"Hackers de sombrero rojo", "Hackers de sombrero blanco", "Hackers de sombrero negro", "No"},
            {"100 a 120", "50 o 30", "100 o 300", "120 o 80"},
            {"Ctrl+X", "Ctrl+Z", "Es el cerebro de cualquier dispositivo electrónico", "Es el encargado de hacer el llamado"},
            {"Power Point", "Visual Basic", "Excel", "Word"},
            {"Para borrar datos", "Para presionar un botón", "Para ingresar información", "Para leer"}
        }

        Label5.Text = Preguntas(PreguntaActual)

        ' Cargar texto de opciones en los RadioButtons
        For i As Integer = 0 To 3
            OpcionesRB(i).Text = Opciones(PreguntaActual, i)
            OpcionesRB(i).Checked = False
        Next
    End Sub

    Sub ActualizarTiempo()
        Dim Minutos As Integer = TiempoRestante \ 60
        Dim Segundos As Integer = TiempoRestante Mod 60
        Label4.Text = "Tiempo: " & Minutos.ToString("00") & ":" & Segundos.ToString("00")
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles Timer1.Tick
        TiempoRestante -= 1
        ActualizarTiempo()

        If TiempoRestante <= 0 Then
            Timer1.Stop()
            MessageBox.Show("¡Tiempo Agotado! Puntos Finales: " & Puntos)
        End If
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Dim respondio As Boolean = False

        For i As Integer = 0 To 3
            If OpcionesRB(i).Checked Then
                respondio = True
                If (i + 1) = Correctas(PreguntaActual) Then
                    MessageBox.Show("¡Correcto! +5 puntos")
                    Puntos += 5
                    RespuestasCorrectas += 1
                Else
                    MessageBox.Show("Incorrecto. La respuesta correcta era: " & OpcionesRB(Correctas(PreguntaActual) - 1).Text)
                End If
            End If
        Next

        If Not respondio Then
            MessageBox.Show("Debes seleccionar una respuesta antes de continuar.")
            Exit Sub
        End If

        Label3.Text = "Puntos: " & Puntos
        PreguntaActual += 1

        If PreguntaActual >= 20 Then
            Timer1.Stop()
            MessageBox.Show("¡Juego Terminado!" & vbCrLf &
                            "Respuestas Correctas: " & RespuestasCorrectas & vbCrLf &
                            "Puntos Finales: " & Puntos)
        Else
            CargarPregunta()
        End If
    End Sub

    Private Sub Label2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label2.Click

    End Sub
End Class

