﻿Public Class Form6

    ' Variables del juego
    Dim puntos As Integer = 100
    Dim tiempoRestante As Integer = 120 ' 2 minutos
    Dim direccion As String = "DERECHA"
    Dim cabeza As PictureBox
    Dim manzana As PictureBox
    Dim cuerpo As New List(Of PictureBox)
    Dim tamanoCuadro As Integer = 20

    ' Inicializar el juego
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Load
        Me.DoubleBuffered = True
        Me.KeyPreview = True
        IniciarJuego()
        Timer1.Interval = 1000
        Timer2.Interval = 200
        Timer1.Start()
        Timer2.Start()
    End Sub

    ' Empezar nuevo juego
    Sub IniciarJuego()
        Button1.Enabled = False
        Button2.Enabled = False

        For Each segmento In cuerpo
            Controls.Remove(segmento)
        Next
        cuerpo.Clear()

        If manzana IsNot Nothing Then Controls.Remove(manzana)

        puntos = 100
        tiempoRestante = 120
        direccion = "DERECHA"

        cabeza = New PictureBox With {
            .Width = tamanoCuadro,
            .Height = tamanoCuadro,
            .BackColor = Color.Green,
            .Location = New Point(100, 100)
        }
        Controls.Add(cabeza)
        cuerpo.Add(cabeza)

        CrearManzana()
        ActualizarPuntos()
        ActualizarTiempo()
    End Sub

    ' Crear nueva manzana (corregida para alinear con cuadrícula)
    Sub CrearManzana()
        If manzana IsNot Nothing Then Controls.Remove(manzana)

        Dim rand As New Random
        Dim maxCols As Integer = Me.ClientSize.Width \ tamanoCuadro
        Dim maxRows As Integer = Me.ClientSize.Height \ tamanoCuadro
        Dim x As Integer = rand.Next(0, maxCols) * tamanoCuadro
        Dim y As Integer = rand.Next(0, maxRows) * tamanoCuadro

        manzana = New PictureBox With {
            .Width = tamanoCuadro,
            .Height = tamanoCuadro,
            .BackColor = Color.Red,
            .Location = New Point(x, y)
        }

        Controls.Add(manzana)
        manzana.BringToFront()
    End Sub

    Sub ActualizarPuntos()
        Label1.Text = "Puntos: " & puntos
    End Sub

    Sub ActualizarTiempo()
        Dim minutos As Integer = tiempoRestante \ 60
        Dim segundos As Integer = tiempoRestante Mod 60
        Label2.Text = "Tiempo: " & minutos.ToString("00") & ":" & segundos.ToString("00")
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles Timer1.Tick
        tiempoRestante -= 1
        ActualizarTiempo()

        If tiempoRestante Mod 20 = 0 And tiempoRestante > 0 Then
            puntos -= 5
            ActualizarPuntos()
        End If

        If tiempoRestante <= 0 Then
            Timer1.Stop()
            Timer2.Stop()
            MessageBox.Show("¡Tiempo agotado! Puntos finales: " & puntos)
            Button1.Enabled = True
            Button2.Enabled = True
        End If
    End Sub

    Private Sub Timer2_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles Timer2.Tick
        MoverSerpiente()
        VerificarColisionManzana()
        VerificarColisionCuerpo()
    End Sub

    Sub MoverSerpiente()
        Dim posicionesAnteriores As New List(Of Point)
        For Each segmento In cuerpo
            posicionesAnteriores.Add(segmento.Location)
        Next

        Select Case direccion
            Case "ARRIBA"
                cabeza.Top -= tamanoCuadro
            Case "ABAJO"
                cabeza.Top += tamanoCuadro
            Case "IZQUIERDA"
                cabeza.Left -= tamanoCuadro
            Case "DERECHA"
                cabeza.Left += tamanoCuadro
        End Select

        For i As Integer = 1 To cuerpo.Count - 1
            cuerpo(i).Location = posicionesAnteriores(i - 1)
        Next

        If cabeza.Left < 0 Or cabeza.Left >= Me.ClientSize.Width Or
           cabeza.Top < 0 Or cabeza.Top >= Me.ClientSize.Height Then
            GameOver()
        End If
    End Sub

    Sub VerificarColisionManzana()
        If cabeza.Bounds.IntersectsWith(manzana.Bounds) Then
            Dim nuevoSegmento As New PictureBox With {
                .Width = tamanoCuadro,
                .Height = tamanoCuadro,
                .BackColor = Color.LightGreen,
                .Location = cuerpo(cuerpo.Count - 1).Location
            }
            Controls.Add(nuevoSegmento)
            cuerpo.Add(nuevoSegmento)

            puntos += 20
            ActualizarPuntos()
            CrearManzana()
        End If
    End Sub

    Sub VerificarColisionCuerpo()
        For i As Integer = 1 To cuerpo.Count - 1
            If cabeza.Bounds.IntersectsWith(cuerpo(i).Bounds) Then
                GameOver()
                Exit For
            End If
        Next
    End Sub

    Sub GameOver()
        Timer1.Stop()
        Timer2.Stop()
        MessageBox.Show("¡Game Over! Puntos finales: " & puntos)
        Button1.Enabled = True
        Button2.Enabled = True
    End Sub

    Private Sub Form1_KeyDown(ByVal sender As Object, ByVal e As KeyEventArgs) Handles Me.KeyDown
        Select Case e.KeyCode
            Case Keys.Up
                If direccion <> "ABAJO" Then direccion = "ARRIBA"
            Case Keys.Down
                If direccion <> "ARRIBA" Then direccion = "ABAJO"
            Case Keys.Left
                If direccion <> "DERECHA" Then direccion = "IZQUIERDA"
            Case Keys.Right
                If direccion <> "IZQUIERDA" Then direccion = "DERECHA"
        End Select
    End Sub

    Private Sub Button1_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Button1.Click
        Timer1.Stop()
        Timer2.Stop()
        IniciarJuego()
        Timer1.Start()
        Timer2.Start()
    End Sub

    Private Sub Button2_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Button2.Click
        Me.Close()
    End Sub


End Class