﻿Public Class Form6
    ' Variables del juego
    Dim puntos As Integer = 0
    Dim tiempoRestante As Integer = 120 ' 2 minutos
    Dim direccion As String = "DERECHA"
    Dim cabeza As PictureBox
    Dim manzana As PictureBox
    Dim cuerpo As New List(Of PictureBox)
    Dim tamanoCuadro As Integer = 20

    ' Auxiliares
    Private rand As New Random()
    Private ultimaPosicionCola As Point

    ' Inicializar el juego
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Load
        Me.DoubleBuffered = True
        Me.KeyPreview = True
        IniciarJuego()
        Timer1.Interval = 1000
        Timer2.Interval = 200
        Timer1.Start()
        Timer2.Start()
    End Sub

    ' Empezar nuevo juego
    Sub IniciarJuego()
        Button1.Enabled = False
        Button2.Enabled = False

        For Each segmento In cuerpo
            Controls.Remove(segmento)
        Next
        cuerpo.Clear()

        If manzana IsNot Nothing Then Controls.Remove(manzana)

        puntos = 0
        tiempoRestante = 120
        direccion = "DERECHA"

        cabeza = New PictureBox With {
            .Width = tamanoCuadro,
            .Height = tamanoCuadro,
            .BackColor = Color.Green,
            .Location = New Point(100, 100)
        }
        Controls.Add(cabeza)
        cuerpo.Add(cabeza)

        CrearManzana()
        ActualizarPuntos()
        ActualizarTiempo()
    End Sub

    ' Crear nueva manzana (no sobre la serpiente)
    Sub CrearManzana()
        If manzana IsNot Nothing Then Controls.Remove(manzana)

        Dim maxCols As Integer = Math.Max(1, Me.ClientSize.Width \ tamanoCuadro)
        Dim maxRows As Integer = Math.Max(1, Me.ClientSize.Height \ tamanoCuadro)
        Dim x As Integer
        Dim y As Integer
        Dim valido As Boolean

        Do
            x = rand.Next(0, maxCols) * tamanoCuadro
            y = rand.Next(0, maxRows) * tamanoCuadro
            Dim r As New Rectangle(x, y, tamanoCuadro, tamanoCuadro)

            valido = True
            For Each seg In cuerpo
                If r.IntersectsWith(New Rectangle(seg.Location, seg.Size)) Then
                    valido = False
                    Exit For
                End If
            Next
            ' Si por alguna razón el tablero está lleno, salimos (defensa)
            ' pero en práctica raramente sucederá.
        Loop Until valido

        manzana = New PictureBox With {
            .Width = tamanoCuadro,
            .Height = tamanoCuadro,
            .BackColor = Color.Red,
            .Location = New Point(x, y)
        }

        Controls.Add(manzana)
        manzana.BringToFront()
    End Sub

    Sub ActualizarPuntos()
        Label1.Text = "Puntos: " & puntos
    End Sub

    Sub ActualizarTiempo()
        Dim minutos As Integer = tiempoRestante \ 60
        Dim segundos As Integer = tiempoRestante Mod 60
        Label2.Text = "Tiempo: " & minutos.ToString("00") & ":" & segundos.ToString("00")
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles Timer1.Tick
        tiempoRestante -= 1
        ActualizarTiempo()

        ' He removido la penalización automática de puntos por tiempo
        ' para que cada manzana valga exactamente 1 punto.
        If tiempoRestante <= 0 Then
            Timer1.Stop()
            Timer2.Stop()
            MessageBox.Show("¡Tiempo agotado! Puntos finales: " & puntos)
            Button1.Enabled = True
            Button2.Enabled = True
        End If
    End Sub

    Private Sub Timer2_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles Timer2.Tick
        MoverSerpiente()
        VerificarColisionManzana()
        VerificarColisionCuerpo()
    End Sub

    Sub MoverSerpiente()
        ' Guardamos posiciones anteriores para poder mover cuerpo
        Dim posicionesAnteriores As New List(Of Point)
        For Each segmento In cuerpo
            posicionesAnteriores.Add(segmento.Location)
        Next

        ' Guardamos la última posición de la cola antes de mover
        ultimaPosicionCola = posicionesAnteriores(posicionesAnteriores.Count - 1)

        ' Mover cabeza
        Select Case direccion
            Case "ARRIBA"
                cabeza.Top -= tamanoCuadro
            Case "ABAJO"
                cabeza.Top += tamanoCuadro
            Case "IZQUIERDA"
                cabeza.Left -= tamanoCuadro
            Case "DERECHA"
                cabeza.Left += tamanoCuadro
        End Select

        ' Mover resto del cuerpo a la posición anterior del segmento de delante
        For i As Integer = 1 To cuerpo.Count - 1
            cuerpo(i).Location = posicionesAnteriores(i - 1)
        Next

        ' Verificar colisión con paredes
        If cabeza.Left < 0 Or cabeza.Left >= Me.ClientSize.Width Or
           cabeza.Top < 0 Or cabeza.Top >= Me.ClientSize.Height Then
            GameOver()
        End If
    End Sub

    ' Al comer manzana: crecer y sumar 1 punto (hasta 100)
    Sub VerificarColisionManzana()
        If manzana Is Nothing Then Return

        If cabeza.Bounds.IntersectsWith(manzana.Bounds) Then
            ' Sumamos 1 punto (máximo 100)
            If puntos < 100 Then
                puntos += 1
            End If
            ActualizarPuntos()

            ' Crear nuevo segmento en la última posición de la cola (antes de mover)
            Dim nuevoSegmento As New PictureBox With {
                .Width = tamanoCuadro,
                .Height = tamanoCuadro,
                .BackColor = Color.LightGreen,
                .Location = ultimaPosicionCola
            }
            Controls.Add(nuevoSegmento)
            cuerpo.Add(nuevoSegmento)

            ' Si llegaste a 100 puntos, ganas
            If puntos >= 100 Then
                Timer1.Stop()
                Timer2.Stop()
                MessageBox.Show("¡Felicidades! Has llegado a 100 puntos y GANASTE.")
                Button1.Enabled = True
                Button2.Enabled = True
                Return
            End If

            ' Si no ganaste aún, crear otra manzana
            CrearManzana()
        End If
    End Sub

    ' Verificar colisión con el cuerpo (no cuenta la cabeza)
    Sub VerificarColisionCuerpo()
        For i As Integer = 1 To cuerpo.Count - 1
            If cabeza.Bounds.IntersectsWith(cuerpo(i).Bounds) Then
                GameOver()
                Exit For
            End If
        Next
    End Sub

    Sub GameOver()
        Timer1.Stop()
        Timer2.Stop()
        MessageBox.Show("¡Game Over! Puntos finales: " & puntos)
        Button1.Enabled = True
        Button2.Enabled = True
    End Sub

    Private Sub Form1_KeyDown(ByVal sender As Object, ByVal e As KeyEventArgs) Handles Me.KeyDown
        Select Case e.KeyCode
            Case Keys.Up
                If direccion <> "ABAJO" Then direccion = "ARRIBA"
            Case Keys.Down
                If direccion <> "ARRIBA" Then direccion = "ABAJO"
            Case Keys.Left
                If direccion <> "DERECHA" Then direccion = "IZQUIERDA"
            Case Keys.Right
                If direccion <> "IZQUIERDA" Then direccion = "DERECHA"
        End Select
    End Sub

    Private Sub Button1_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Button1.Click
        Timer1.Stop()
        Timer2.Stop()
        IniciarJuego()
        Timer1.Start()
        Timer2.Start()
    End Sub

    Private Sub Button2_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Button2.Click
        Me.Close()
    End Sub

End Class
