<?php
// --- INICIO DE SESIÓN ---
session_start();

$usuario_valido = "admin";
$clave_valida   = "1234";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $usuario = $_POST['username'] ?? '';
    $clave   = $_POST['password'] ?? '';

    if ($usuario === $usuario_valido && $clave === $clave_valida) {
        $_SESSION['login'] = true;
        header("Location: login.php"); // redirige al panel principal
        exit;
    } else {
        $error = "❌ Usuario o contraseña incorrectos";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Inicio de Sesión - Gestión de Alumnos</title>
<style>
    body {
        margin: 0;
        font-family: 'Segoe UI', sans-serif;
        background: linear-gradient(120deg, #2563eb, #1e3a8a);
        height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        background-attachment: fixed;
        background-size: cover;
    }

    .container {
        text-align: center;
        width: 100%;
        max-width: 400px;
    }

    .login-box {
        background: #ffffffdd;
        padding: 40px 30px;
        border-radius: 20px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.3);
        animation: fadeIn 1s ease-in-out;
        position: relative;
    }

    .login-box::before {
        content: "🎓";
        font-size: 50px;
        position: absolute;
        top: -35px;
        left: calc(50% - 25px);
        background: #2563eb;
        color: white;
        padding: 10px;
        border-radius: 50%;
        box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    }

    .login-box h2 {
        margin-top: 25px;
        color: #1e3a8a;
        font-size: 26px;
        font-weight: bold;
    }

    .login-box p {
        margin-bottom: 25px;
        color: #4b5563;
        font-size: 14px;
    }

    .login-box input {
        width: 85%;
        padding: 12px;
        margin: 12px 0;
        border-radius: 10px;
        border: 1px solid #d1d5db;
        outline: none;
        transition: 0.3s;
        font-size: 15px;
    }

    .login-box input:focus {
        border-color: #2563eb;
        box-shadow: 0 0 6px rgba(37, 99, 235, 0.4);
    }

    .login-box button {
        margin-top: 15px;
        width: 90%;
        padding: 12px;
        border: none;
        border-radius: 10px;
        background: linear-gradient(90deg, #2563eb, #1e40af);
        color: white;
        font-size: 16px;
        font-weight: bold;
        cursor: pointer;
        transition: 0.3s;
    }

    .login-box button:hover {
        background: linear-gradient(90deg, #1e40af, #1e3a8a);
    }

    .error {
        margin-top: 15px;
        color: #dc2626;
        font-weight: bold;
    }

    footer {
        margin-top: 20px;
        font-size: 13px;
        color: #e5e7eb;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>
</head>
<body>

<div class="container">
    <div class="login-box">
        <h2>Gestión de Alumnos</h2>
        <p>Inicia sesión para acceder al sistema</p>
        <form method="POST" action="">
            <input type="text" name="username" placeholder="👤 Usuario" required><br>
            <input type="password" name="password" placeholder="🔒 Contraseña" required><br>
            <button type="submit">Ingresar</button>
        </form>
        <?php if (isset($error)) echo "<div class='error'>$error</div>"; ?>
    </div>
    <footer>© 2025 Sistema de Gestión Escolar</footer>
</div>

</body>
</html>
