<?php
// --- Proteger acceso ---
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: index.php"); // si no hay sesión activa, volver al login
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Gestión de Alumnos</title>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        background-color: #f0f2f5;
        color: #333;
        display: flex;
    }
    /* Barra lateral */
    .sidebar {
        width: 200px;
        background: #1e40af;
        color: white;
        height: 100vh;
        padding-top: 20px;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
    }
    .sidebar h2 {
        text-align: center;
        width: 100%;
        margin-bottom: 20px;
        font-size: 18px;
    }
    .sidebar button {
        width: 100%;
        padding: 12px;
        border: none;
        background: none;
        color: white;
        text-align: left;
        cursor: pointer;
        font-size: 16px;
        transition: 0.3s;
    }
    .sidebar button:hover {
        background: #2563eb;
    }
    /* Contenido */
    .content {
        flex: 1;
        padding: 20px;
    }
    header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: #1e40af;
        color: white;
        padding: 15px 20px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }
    header h1 {
        margin: 0;
        font-size: 20px;
    }
    .logout-btn {
        background: #ef4444;
        border: none;
        padding: 8px 15px;
        border-radius: 5px;
        color: white;
        cursor: pointer;
        font-weight: bold;
        transition: 0.3s;
    }
    .logout-btn:hover {
        background: #b91c1c;
    }
    .screen {
        display: none;
    }
    .active {
        display: block;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
        background-color: #fff;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    th, td {
        border: 1px solid #ddd;
        padding: 10px;
        text-align: left;
    }
    th {
        background-color: #3b82f6;
        color: white;
    }
    tr:nth-child(even) {
        background-color: #f9fafb;
    }
    button.add, button.delete {
        padding: 6px 10px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        margin-bottom: 10px;
        margin-right: 5px;
        color: white;
    }
    button.add { background-color: #10b981; }
    button.add:hover { background-color: #059669; }
    button.delete { background-color: #ef4444; }
    button.delete:hover { background-color: #b91c1c; }
</style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <h2>📘 Menú</h2>
    <button onclick="showScreen('alumnos')">Alumnos</button>
    <button onclick="showScreen('pagos')">Pagos</button>
    <button onclick="showScreen('materias')">Materias</button>
    <button onclick="showScreen('notas')">Notas</button>
    <button onclick="showScreen('asignacion')">Asignación</button>
    <form action="logout.php" method="POST" style="margin-top:auto;width:100%;">
        <button class="logout-btn" type="submit" style="width:100%;">Cerrar Sesión</button>
    </form>
</div>

<!-- Contenido -->
<div class="content">
    <header>
        <h1>Sistema de Gestión de Alumnos</h1>
    </header>

    <!-- Alumnos -->
    <div id="alumnos" class="screen active">
        <h2>Alumnos</h2>
        <button class="add" onclick="addRow('tableAlumnos')">Agregar Alumno</button>
        <table id="tableAlumnos">
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Edad</th>
                <th>Acción</th>
            </tr>
            <tr><td>1</td><td contenteditable="true">Bryan</td><td contenteditable="true">12</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
            <tr><td>2</td><td contenteditable="true">Ángel</td><td contenteditable="true">13</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
				 <tr><td>3</td><td contenteditable="true">Juan</td><td contenteditable="true">16</td>
            <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
				<tr><td>4</td><td contenteditable="true">Pedro</td><td contenteditable="true">3</td>
            <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
        </table>
    </div>

    <!-- Pagos -->
    <div id="pagos" class="screen">
        <h2>Pagos</h2>
        <button class="add" onclick="addRow('tablePagos')">Agregar Pago</button>
        <table id="tablePagos">
            <tr>
                <th>ID</th>
                <th>Alumno</th>
                <th>Monto</th>
                <th>Fecha</th>
                <th>Acción</th>
            </tr>
            <tr><td>1</td><td contenteditable="true">Bryan</td><td contenteditable="true">Q200</td><td contenteditable="true">2025-01-10</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
			<tr><td>2</td><td contenteditable="true">Ángel</td><td contenteditable="true">Q100</td><td contenteditable="true">2025-03-25</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
        </table>
    </div>

    <!-- Materias -->
    <div id="materias" class="screen">
        <h2>Materias</h2>
        <button class="add" onclick="addRow('tableMaterias')">Agregar Materia</button>
        <table id="tableMaterias">
            <tr>
                <th>ID</th>
                <th>Materia</th>
                <th>Profesor</th>
                <th>Acción</th>
            </tr>
            <tr><td>1</td><td contenteditable="true">Matemática</td><td contenteditable="true">Selvin</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
			<tr><td>2</td><td contenteditable="true">Biologia</td><td contenteditable="true">Sender</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
        </table>
    </div>

    <!-- Notas -->
    <div id="notas" class="screen">
        <h2>Notas</h2>
        <button class="add" onclick="addRow('tableNotas')">Agregar Nota</button>
        <table id="tableNotas">
            <tr>
                <th>ID</th>
                <th>Alumno</th>
                <th>Materia</th>
                <th>Nota</th>
                <th>Acción</th>
            </tr>
            <tr><td>1</td><td contenteditable="true">Ángel</td><td contenteditable="true">Matemática</td><td contenteditable="true">85</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
			<tr><td>2</td><td contenteditable="true">Bryan</td><td contenteditable="true">Matemática</td><td contenteditable="true">45</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
        </table>
    </div>

    <!-- Asignación -->
    <div id="asignacion" class="screen">
        <h2>Asignación</h2>
        <button class="add" onclick="addRow('tableAsignacion')">Agregar Asignación</button>
        <table id="tableAsignacion">
            <tr>
                <th>ID</th>
                <th>Alumno</th>
                <th>Materia</th>
                <th>Acción</th>
            </tr>
            <tr><td>1</td><td contenteditable="true">Pedro</td><td contenteditable="true">Historia</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
			<tr><td>2</td><td contenteditable="true">Bryan</td><td contenteditable="true">Matemática</td>
                <td><button class="delete" onclick="deleteRow(this)">Borrar</button></td></tr>
        </table>
    </div>
</div>

<script>
// Cambiar pantalla
function showScreen(screenId) {
    const screens = document.querySelectorAll('.screen');
    screens.forEach(s => s.classList.remove('active'));
    document.getElementById(screenId).classList.add('active');
}
// Agregar fila
function addRow(tableId) {
    const table = document.getElementById(tableId);
    const rowCount = table.rows.length;
    const colCount = table.rows[0].cells.length;
    const row = table.insertRow(rowCount);
    for (let i = 0; i < colCount; i++) {
        const cell = row.insertCell(i);
        if(i === colCount - 1) {
            const btn = document.createElement("button");
            btn.innerText = "Borrar";
            btn.className = "delete";
            btn.onclick = function(){ deleteRow(btn); };
            cell.appendChild(btn);
        } else {
            cell.contentEditable = true;
            cell.innerText = "";
        }
    }
}
// Eliminar fila
function deleteRow(btn) {
    const row = btn.parentNode.parentNode;
    row.parentNode.removeChild(row);
}
</script>

</body>
</html>

