<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Dashboard Tienda</title>
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #74ebd5 0%, #ACB6E5 100%);
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .dashboard {
      width: 420px;
      background: white;
      border-radius: 15px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.3);
      padding: 30px;
      text-align: center;
      animation: aparecer 1s ease;
    }

    @keyframes aparecer {
      from { transform: scale(0.8); opacity: 0; }
      to { transform: scale(1); opacity: 1; }
    }

    h1 {
      color: #ff9800;
      margin-bottom: 10px;
      font-size: 2em;
      text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
    }

    p {
      color: #555;
      margin-bottom: 25px;
      font-weight: 500;
    }

    .menu {
      display: flex;
      flex-direction: column;
      gap: 15px;
    }

    .menu button {
      padding: 12px;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      transition: all 0.3s ease;
      color: white;
      letter-spacing: 1px;
    }

    .menu button:nth-child(1) {
      background: #4caf50;
    }
    .menu button:nth-child(2) {
      background: #2196f3;
    }
    .menu button:nth-child(3) {
      background: #f44336;
    }
    .menu button:nth-child(4) {
      background: #9c27b0;
    }

    .menu button:hover {
      transform: scale(1.05);
      box-shadow: 0 6px 15px rgba(0,0,0,0.2);
    }
  </style>
</head>
<body>
  <div class="dashboard">
    <h1>Bienvenido </h1>
    <p>Nuestra tienda ofrece lo mejor que quieres para tu hogar y a muy buen precio</p>
    <div class="menu">
      <button>ver Productos</button>
      <button>Agregar productos</button>
      <button>Eliminar productos</button>
      <button>cerrar sesion</button>
    </div>
  </div>
</body>
</html>