<?php
// productos.php
$db_host = 'localhost';
$db_name = 'inventario_tienda';
$db_user = 'root';
$db_pass = '';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
    $stmt = $pdo->query("SELECT * FROM productos ORDER BY id DESC");
    $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Error DB: " . $e->getMessage());
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Inventario - Ver productos</title>
  <style>
    body{font-family:Arial,sans-serif;background:#f7f9fc;padding:20px;}
    h1{margin:0 0 20px;}
    a.btn{background:#0f172a;color:#fff;padding:8px 12px;text-decoration:none;border-radius:6px;margin-right:6px;}
    a.btn:hover{background:#1e293b;}
    table{width:100%;border-collapse:collapse;background:#fff;box-shadow:0 4px 10px rgba(0,0,0,0.1);}
    th,td{padding:10px;border:1px solid #ddd;text-align:left;}
    th{background:#0f172a;color:#fff;}
    img{max-width:60px;max-height:60px;object-fit:cover;}
    .acciones a{margin-right:5px;}
  </style>
</head>
<body>
  <h1>Inventario de Productos</h1>
  <a href="agregar.php" class="btn">+ Agregar producto</a>
  <a href="cerrar.php" class="btn" style="background:#ef4444">Cerrar sesión</a>
  <br><br>
  <table>
    <tr>
      <th>ID</th>
      <th>Código</th>
      <th>Nombre</th>
      <th>Categoría</th>
      <th>Precio</th>
      <th>Stock</th>
      <th>Imagen</th>
      <th>Acciones</th>
    </tr>
    <?php foreach($productos as $p): ?>
      <tr>
        <td><?=$p['id']?></td>
        <td><?=htmlspecialchars($p['codigo'])?></td>
        <td><?=htmlspecialchars($p['nombre'])?></td>
        <td><?=htmlspecialchars($p['categoria'])?></td>
        <td>Q <?=number_format($p['precio'],2)?></td>
        <td><?=$p['stock']?></td>
        <td>
          <?php if($p['imagen']): ?>
            <img src="<?=htmlspecialchars($p['imagen'])?>" alt="">
          <?php endif; ?>
        </td>
        <td class="acciones">
          <a href="editar.php?id=<?=$p['id']?>" class="btn">Editar</a>
          <a href="eliminar.php?id=<?=$p['id']?>" class="btn" style="background:#ef4444" onclick="return confirm('¿Eliminar producto?')">Eliminar</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </table>
</body>
</html>